## Авторизация пользователей

Контроллер Login позволяет авторизировать пользователей как по имени, так и по email. Кроме этого, можно дополнительно использовать плагин userHelper, который ведет учет количества логинов и времени последнего логина, а также реализует автологин и выход из учетной записи.

## Параметры контроллера

### model
Класс для работы с пользователями.

Возможные значения - имя класса.

Значение по умолчанию - \modUsers

### modelPath
Путь к файлу класса для работы с пользователями.

Возможные значения - относительный путь к файлу.

Значение по умолчанию - assets/lib/MODxAPI/modUsers.php

### loginField
Поле, содержащее имя пользователя.

Возможные значения - имя поля.

Значение по умолчанию - username.

### passwordField
Поле, содержащее пароль пользователя.

Возможные значения - имя поля.

Значение по умолчанию - password.

### rememberField
Поле для запоминания пользователя. Если значение поля приводится к true, то при успешной авторизации будет установлена кука с параметрами автологина. Имя куки и ее время жизни задаются параметрами cookieName и cookieLifetime.

Можно также задать поле rememberme в параметре defaults, чтобы запоминание происходило без участия пользователя:
```
&defaults=`{"rememberme":1}`
```

Возможные значения - имя поля.

Значение по умолчанию - rememberme.

### checkActivation
Включает проверку активации учетной записи пользователя (см. "Активация учетных записей"). 

Возможные значения - 0 или 1.

Значение по умолчанию - 1.

### context
Контекст авторизации.

Возможные значения - mgr или web.

Значение по умолчанию - web.

### cookieName
Имя куки для хранения параметров автологина.

Значение по умолчанию - WebLoginPE.

### cookieLifetime
Время жизни вышеуказанной куки.

Возможные значения - число секунд с момента последнего логина.

Значение по умолчанию - 157680000 (5 лет).

### redirectTo
Перенаправляет пользователя на страницу c указанным id после авторизации.

Возможные значения - id целевой страницы или массив.

Значение по умолчанию - пусто.

### exitTo
Перенаправляет уже авторизованного пользователя на указанную страницу.

Возможные значения - id целевой страницы или массив.

Значение по умолчанию - пусто.

### successTpl
Шаблон сообщения об успешной авторизации. В шаблоне можно использовать данные пользователя.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Login с ключом [+login.default_successTpl+]

### skipTpl
Шаблон сообщения о том, что пользователь уже авторизован.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Login с ключом [+login.default_skipTpl+]

## Параметры плагина userHelper
### logoutKey
Имя GET-параметра для запуска выхода из учетной записи. Если в ссылке на страницу сайта указан параметр с соответствующим именем (например, http://sitename.ru/page.html?logout), будет произведен выход из учетной записи.

Значение по умолчанию - logout.

### cookieName
Имя куки для хранения параметров автологина.

Значение по умолчанию - WebLoginPE.

### cookieLifetime
Время жизни вышеуказанной куки.

Возможные значения - число секунд с момента последнего логина.

Значение по умолчанию - 157680000 (5 лет).
